// Sample the depth and convert to linear view space Z
float FindLinearDepth(float2 texCoords) {
	float depth = DepthStencilTex.SampleLevel(LinearSampler, texCoords, 0);
	float linearDepth = ProjectionB / (depth - ProjectionA);

	return linearDepth;
}

// Read the depth map and calculate the view space position
// http://mynameismjp.wordpress.com/2010/09/05/position-from-depth-3/
float3 PositionFromDepthViewS(float3 viewRay, float2 texCoords) {
	return viewRay * FindLinearDepth(texCoords);
}

float CalculateCoCRadiusFilmS(float depthViewS) {
	// Distance from lens to object
	float distance = depthViewS - NearClip;

	// CoC parameters
	float S = distance;
	float u = FocalDistance;
	float v = LensDistance;
	float c1 = v * v * abs(S - u);
	float c2 = u * S * FNumber;
	float c = c1 / c2; // CoC diameter

	if(c > kCoCSearchRadius * 2) {
		// Limit the CoC size to reduce the amount of overdraw
		c = kCoCSearchRadius * 2;
	}
	//else if(c < kMinCoCDiameter) {
	//	// Threshold to 0 if the CoC radius is small enough
	//	c = 0;
	//}

	// Convert to radius and return
	return c * 0.5;
}